ALTER TABLE Dependent DISABLE TRIGGER ALL;
ALTER TABLE DeptLocations DISABLE TRIGGER ALL;
ALTER TABLE WorksOn DISABLE TRIGGER ALL;
ALTER TABLE Project DISABLE TRIGGER ALL;
ALTER TABLE Employee DISABLE TRIGGER ALL;
ALTER TABLE Department DISABLE TRIGGER ALL;

DELETE FROM Dependent CASCADE;
DELETE FROM DeptLocations CASCADE;
DELETE FROM WorksOn CASCADE;
DELETE FROM Project CASCADE;
DELETE FROM Employee CASCADE;
DELETE FROM Department CASCADE;

ALTER TABLE Dependent ENABLE TRIGGER ALL;
ALTER TABLE DeptLocations ENABLE TRIGGER ALL;
ALTER TABLE WorksOn ENABLE TRIGGER ALL;
ALTER TABLE Project ENABLE TRIGGER ALL;
ALTER TABLE Employee ENABLE TRIGGER ALL;
ALTER TABLE Department ENABLE TRIGGER ALL;

SET datestyle = "ISO, DMY";

-- The referential integrity in Postgres is implemented by triggers, and you can disable triggers on table.
-- https://stackoverflow.com/questions/38112379/disable-postgresql-foreign-key-checks-for-migrations
ALTER TABLE Employee DISABLE TRIGGER ALL;

INSERT INTO Employee VALUES
('e1', 'James', 'A', 'Borg', '10-11-1927',
'450 Stone, Houston, TX', 'M', 55000, NULL, 1, '01-01-1980'),
('e2', 'Franklin', 'T', 'Wong', '08-12-1945',
'638 Voss, Houston, TX', 'M', 40000, 'e1', 2, '01-01-1982'),
('e3', 'Jennifer', 'S', 'Wallace', '20-06-1931',
'291 Berry, Bellaire, TX', 'F', 43000, 'e1', 3, '01-01-1982'),
('e4', 'Ramesh', 'K', 'Narayan', '15-09-1952',
'975 Fire Oak, Humble, TX', 'M', 38000, 'e2', 3, '01-01-1985'),
('e5', 'John', 'B', 'Smith', '09-05-1955',
'731 Fondren, Houston, TX', 'M', 30000, 'e2', 3, '01-01-1985'),
('e6', 'Joyce', 'A', 'English', '31-07-1962',
'5631 Rice, Houston, TX', 'F', 25000, 'e2', 3, '01-01-1985'),
('e7', 'Ahmad', 'V', 'Jabbar', '29-03-1959',
'980 Dallas, Houston, TX', 'M', 25000, 'e3', 2, '01-01-1985'),
('e8', 'Alicia', 'J', 'Zelaya', '19-07-1958',
'3321 Castle, Spring, TX', 'F', 25000, 'e3', 2, '01-01-1985'),
('e9', 'Mary', 'A', 'Stuart', '10-11-1959',
'450 Stone, Houston, TX', 'M', 24000, 'e8', 1, '01-01-1990');

ALTER TABLE Employee ENABLE TRIGGER ALL;

INSERT INTO Department VALUES
(1, 'Headquarters', 'e1', '19-06-1971', 2),
(2, 'Administration', 'e2', '01-01-1985', 3),
(3, 'Research', 'e3', '22-05-1978', 4);
  
INSERT INTO DeptLocations VALUES
(1, 'Houston'),
(2, 'Stafford'),
(3, 'Bellaire'),
(3, 'Sugarland'),
(3, 'Houston');

/* The DISABLE/ENABLE below is needed to take into account the triggers 
   that are insertedas solution of the exercises */
ALTER TABLE Project DISABLE TRIGGER ALL;
ALTER TABLE WorksOn DISABLE TRIGGER ALL;

INSERT INTO Project VALUES
(1, 'ProductX', 'Bellaire', 3),
(2, 'ProductY', 'Sugarland', 3),
(3, 'ProductZ', 'Houston', 3),
(10, 'Reorganization', 'Houston', 1),
(20, 'Computerization', 'Stafford', 2),
(30, 'Newbenefits', 'Stafford', 2);

INSERT INTO WorksOn VALUES
('e1', 10, 30.0),
('e2', 10, 10.0),
('e2', 20, 10.0),
('e2', 30, 20.0),
('e3', 1, 5.0),
('e3', 2, 15.0),
('e3', 3, 20.0),
('e4', 3, 40.0),
('e5', 1, 32.5),
('e5', 2, 10.0),
('e6', 1, 20.0),
('e6', 2, 20.0),
('e7', 20, 35.0),
('e7', 30, 10),
('e8', 20, 10.0),
('e8', 30, 30.0);

ALTER TABLE Project ENABLE TRIGGER ALL;
ALTER TABLE WorksOn ENABLE TRIGGER ALL;

INSERT INTO Dependent VALUES
('e2', 'Alice', 'F', '05-04-1976', 'Daughter'),
('e2', 'Theodore', 'M', '25-10-1973', 'Son'),
('e2', 'Joy', 'F', '03-05-1948', 'Spouse'),
('e3', 'Abner', 'M', '29-02-1932', 'Spouse'),
('e5', 'Michael', 'M', '01-01-1978', 'Son'),
('e5', 'Alice', 'F', '31-12-1978', 'Daughter'),
('e5', 'Elizabeth', 'F', '05-05-1957', 'Spouse');




