DROP TABLE IF EXISTS Employee CASCADE;
CREATE TABLE Employee (
  EmpId varchar(9) NOT NULL,
  FName varchar(15) NOT NULL,
  MInit char(1),
  LName varchar(15) NOT NULL,
  BDate date NULL,
  Address varchar(30),
  Gender char(1),
  Salary decimal(18,2),
  SuperId varchar(9),
  DNumber int NOT NULL,
  HireDate date NULL,
  CONSTRAINT PK_Employee PRIMARY KEY (EmpId),
  CONSTRAINT FK_Employee_Employee FOREIGN KEY (SuperId) REFERENCES Employee(EmpId)
);

DROP TABLE IF EXISTS Department CASCADE;
CREATE TABLE Department (
  DNumber int NOT NULL,
  DName varchar(15) NOT NULL,
  MgrId varchar(9) NOT NULL,
  MgrStartDate date,
  NoEmployees int,
  CONSTRAINT PK_Department PRIMARY KEY (DNumber),
  CONSTRAINT FK_Department_Employee FOREIGN KEY (MgrId) REFERENCES Employee(EmpId) 
    ON DELETE CASCADE ON UPDATE CASCADE 
); 

ALTER TABLE Employee
  ADD CONSTRAINT FK_Employee_Department FOREIGN KEY (DNumber) REFERENCES Department(DNumber);

DROP TABLE IF EXISTS Project CASCADE;
CREATE TABLE Project (
  PNumber int NOT NULL,
  PName varchar(15) NOT NULL,
  PLocation varchar(15),
  DNumber int NOT NULL,
  CONSTRAINT PK_Project PRIMARY KEY (PNumber),
  CONSTRAINT FK_Project_Department FOREIGN KEY (DNumber) REFERENCES Department(DNumber)
);

DROP TABLE IF EXISTS DeptLocations CASCADE;
CREATE TABLE DeptLocations (
  DNumber int NOT NULL,
  DLocation varchar(15) NOT NULL,
  CONSTRAINT PK_Dept_Locations PRIMARY KEY (DNumber,DLocation),
  CONSTRAINT FK_Dept_Locations_Department FOREIGN KEY (DNumber) REFERENCES Department(DNumber)
);

DROP TABLE IF EXISTS Dependent CASCADE;
CREATE TABLE Dependent (
  EmpId varchar(9) NOT NULL,
  DependentName varchar(15) NOT NULL,
  Gender char(1),
  BDate date NULL,
  Relationship varchar(8),
  CONSTRAINT PK_Dependent PRIMARY KEY (EmpId,DependentName),
  CONSTRAINT FK_Dependent_Employee FOREIGN KEY (EmpId) REFERENCES Employee(EmpId)
);

DROP TABLE IF EXISTS WorksOn CASCADE;
CREATE TABLE WorksOn (
  EmpId varchar(9) NOT NULL,
  PNumber int NOT NULL,
  hours decimal(18,1) NOT NULL,
  CONSTRAINT PK_WorksOn PRIMARY KEY (EmpId,PNumber),
  CONSTRAINT FK_WorksOn_Employee FOREIGN KEY (EmpId) REFERENCES Employee(EmpId),
  CONSTRAINT FK_WorksOn_Project FOREIGN KEY (PNumber) REFERENCES Project(PNumber)
);
